<?php
require_once __DIR__ . '/../config/auth.php';

// Redirect if already logged in
redirectIfLoggedIn();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- CSS FILE LINKS -->
    <link rel="stylesheet" href="/css/global.css">
    <link rel="stylesheet" href="/css/login.css">
    <link rel="stylesheet" href="/css/alert.css">
    <!-- WEBSITE TITLE -->
    <title>Dashboard login</title>
</head>

<body>

    <div class="loginScreen">
        
        <form class="form" id="loginForm">
            <div class="flex-column">
                <label>Email</label>
            </div>
            <div class="inputForm">
                <svg height="20" viewBox="0 0 32 32" width="20" xmlns="http://www.w3.org/2000/svg">
                    <g id="Layer_3" data-name="Layer 3">
                        <path
                            d="m30.853 13.87a15 15 0 0 0 -29.729 4.082 15.1 15.1 0 0 0 12.876 12.918 15.6 15.6 0 0 0 2.016.13 14.85 14.85 0 0 0 7.715-2.145 1 1 0 1 0 -1.031-1.711 13.007 13.007 0 1 1 5.458-6.529 2.149 2.149 0 0 1 -4.158-.759v-10.856a1 1 0 0 0 -2 0v1.726a8 8 0 1 0 .2 10.325 4.135 4.135 0 0 0 7.83.274 15.2 15.2 0 0 0 .823-7.455zm-14.853 8.13a6 6 0 1 1 6-6 6.006 6.006 0 0 1 -6 6z">
                        </path>
                    </g>
                </svg>
                <input type="email" name="admin-email" id="admin-email" class="input" placeholder="Enter your Email" required />
            </div>

            <div class="flex-column">
                <label>Password</label>
            </div>
            <div class="inputForm">
                <svg height="20" viewBox="-64 0 512 512" width="20" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="m336 512h-288c-26.453125 0-48-21.523438-48-48v-224c0-26.476562 21.546875-48 48-48h288c26.453125 0 48 21.523438 48 48v224c0 26.476562-21.546875 48-48 48zm-288-288c-8.8125 0-16 7.167969-16 16v224c0 8.832031 7.1875 16 16 16h288c8.8125 0 16-7.167969 16-16v-224c0-8.832031-7.1875-16-16-16zm0 0">
                    </path>
                    <path
                        d="m304 224c-8.832031 0-16-7.167969-16-16v-80c0-52.929688-43.070312-96-96-96s-96 43.070312-96 96v80c0 8.832031-7.167969 16-16 16s-16-7.167969-16-16v-80c0-70.59375 57.40625-128 128-128s128 57.40625 128 128v80c0 8.832031-7.167969 16-16 16zm0 0">
                    </path>
                </svg>
                <input type="password" name="admin-password" id="admin-password" class="input" placeholder="Enter your Password" required />
            </div>

            <button type="submit" class="button-submit">Sign In</button>
        </form>

    </div>

    <div class="alert" id="alert">
        <div class="info">
            <div class="info__title" id="alert-message">lorem ipsum dolor sit amet</div>
            <button class="info__close" id="alert-close"><svg xmlns="http://www.w3.org/2000/svg" width="20" viewBox="0 0 20 20"
                    height="20">
                    <path fill="#393a37"
                        d="m15.8333 5.34166-1.175-1.175-4.6583 4.65834-4.65833-4.65834-1.175 1.175 4.65833 4.65834-4.65833 4.6583 1.175 1.175 4.65833-4.6583 4.6583 4.6583 1.175-1.175-4.6583-4.6583z">
                    </path>
                </svg></button>
        </div>
    </div>

    <script>
        // Login form handler
        document.getElementById('loginForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const email = document.getElementById('admin-email').value;
            const password = document.getElementById('admin-password').value;
            
            try {
                const response = await fetch('/api/login.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ email, password })
                });
                
                const data = await response.json();
                
                if (data.success) {
                    showAlert(data.message, 'success');
                    setTimeout(() => {
                        window.location.href = data.redirect;
                    }, 1000);
                } else {
                    showAlert(data.message, 'error');
                }
            } catch (error) {
                showAlert('Network error. Please try again.', 'error');
            }
        });
        
        // Alert functions
        function showAlert(message, type = 'info') {
            const alert = document.getElementById('alert');
            const alertMessage = document.getElementById('alert-message');
            alertMessage.textContent = message;
            alert.classList.add('show');
            
            // Auto hide after 5 seconds
            setTimeout(() => {
                hideAlert();
            }, 5000);
        }
        
        function hideAlert() {
            const alert = document.getElementById('alert');
            alert.classList.remove('show');
        }
        
        // Close button
        document.getElementById('alert-close').addEventListener('click', hideAlert);
        
        // Hide alert initially
        document.getElementById('alert').classList.remove('show');
    </script>

</body>

</html>
